VERSION 2.00
Begin Form frmBaseConv 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Number Base Converter"
   ClientHeight    =   3300
   ClientLeft      =   1455
   ClientTop       =   1965
   ClientWidth     =   7290
   Height          =   3990
   HelpContextID   =   10
   Icon            =   BASECONV.FRX:0000
   Left            =   1395
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3300
   ScaleWidth      =   7290
   Top             =   1335
   Width           =   7410
   Begin ComboBox cboBase 
      Height          =   315
      Left            =   4530
      TabIndex        =   2
      Text            =   "Combo1"
      Top             =   1095
      Width           =   885
   End
   Begin CommandButton cmdClear 
      Caption         =   "Clear"
      Height          =   375
      Left            =   2280
      TabIndex        =   1
      Top             =   1080
      Width           =   975
   End
   Begin TextBox txtDisplay 
      Alignment       =   1  'Right Justify
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   360
      Left            =   480
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   360
      Width           =   6615
   End
   Begin Label lblInstructions 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "To convert a number, first select the base it is stored in from the drop-down list. Then type the number into the white display panel, then select the base it should be converted to. To clear the display, click ""Clear""."
      ForeColor       =   &H000000C0&
      Height          =   975
      Left            =   960
      TabIndex        =   4
      Top             =   1920
      Width           =   5535
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Caption         =   "Base:"
      Height          =   255
      Left            =   3810
      TabIndex        =   3
      Top             =   1140
      Width           =   615
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Index           =   1
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
         Index           =   2
         Shortcut        =   ^{F4}
      End
   End
   Begin Menu mnuEdit 
      Caption         =   "&Edit"
      Index           =   3
      Begin Menu mnuEditCut 
         Caption         =   "Cu&t"
         Index           =   4
         Shortcut        =   ^X
      End
      Begin Menu mnuEditCopy 
         Caption         =   "&Copy"
         Index           =   5
         Shortcut        =   ^C
      End
      Begin Menu mnuEditPaste 
         Caption         =   "&Paste"
         Index           =   6
         Shortcut        =   ^V
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "&Help"
      Index           =   7
      Begin Menu mnuHelpContents 
         Caption         =   "&Contents"
         Index           =   8
      End
      Begin Menu mnuHelpRegisteringInfo 
         Caption         =   "Registering &Info"
         Index           =   9
      End
      Begin Menu mnuHelpRegister 
         Caption         =   "&Register"
         Index           =   10
      End
      Begin Menu mnuHelpSep1 
         Caption         =   "-"
         Index           =   11
      End
      Begin Menu mnuHelpAbout 
         Caption         =   "&About"
         Index           =   12
      End
   End
End
Option Explicit

'Declare a variable used throughout this form to hold
'the number base the number stored in the display is in.
Dim Current_Base As Integer


'Declare a variable used throughout this form to hold
'the number on the display
Dim Display As String

Sub cboBase_Click ()

'If there is a number stored on the display text box
'txtDisplay, the functions held in the module BASES.BAS
'are used to convert it.


Dim BaseToConvertFrom As Integer
Dim temp As Double
Dim Result As String


BaseToConvertFrom = Current_Base
Current_Base = cboBase.ListIndex + 2



'Check if the display is blank. If it is, nothing needs
'changing so we can exit this SUB

If Display = "" Then
    txtDisplay.SetFocus
    Exit Sub
End If




If BaseToConvertFrom <> 10 Then
    temp = BaseToDecimal(Display, BaseToConvertFrom)
    Result = DecimalToBase(temp, Current_Base)
Else
    Result = DecimalToBase(Val(Display), Current_Base)
End If

txtDisplay = Result

'Set the focus to the display
txtDisplay.SetFocus

End Sub

Sub cmdClear_Click ()

'Clears the display
txtDisplay = ""

'Sets the focus back to the display
txtDisplay.SetFocus

End Sub

Sub cmdNumber_Click (Index As Integer)

'When a button marked with a number is clicked,
'this code adds the number of the button to the display
'at the top of the form, like a calculator.

txtDisplay = txtDisplay + Format$(Index)

End Sub

Sub Form_Load ()

'Set up the help file
SetApphelp Me.hWnd


Dim count As Integer    'Used for adding numbers to the
                        'combo box

'Show the form
frmBaseConv.Show

'Set the focus to the display
txtDisplay.SetFocus

'Add base numbers to the combo box
For count = 2 To 36
    cboBase.AddItem Format$(count)
Next count

'Set base numbers combo box to base 10.
'The combo box starts numbering at 0, and there is
'no base 1, so the ListIndex for base 10 is 8.

cboBase.ListIndex = 8
Current_Base = 10


'Blank the display

txtDisplay = ""

End Sub

Sub Form_UnLoad (Cancel As Integer)
'*** Code added by HelpWriter ***
'*** Subroutine added by HelpWriter ***
    QuitHelp
'***********************************
End Sub

Sub mnuEditCopy_Click (Index As Integer)

'Prevents a run-time error if a control does not support copy
On Error Resume Next


' Clear Clipboard
  Clipboard.Clear

' Copy text to Clipboard.
  Clipboard.SetText txtDisplay

End Sub

Sub mnuEditCut_Click (Index As Integer)

'Prevents a run-time error if a control does not support cut
On Error Resume Next

' Clear Clipboard
  Clipboard.Clear

' Copy text to Clipboard.
  Clipboard.SetText txtDisplay

' Delete selected text.
  Screen.ActiveControl.SelText = ""

End Sub

Sub mnuEditPaste_Click (Index As Integer)

'Prevents a run-time error if a control does not support paste
On Error Resume Next

' Place text from Clipboard into active control.
  Screen.ActiveControl.SelText = Clipboard.GetText()

End Sub

Sub mnuFileExit_Click (Index As Integer)

'Quits the program

End

End Sub

Sub mnuHelpABout_Click (Index As Integer)

'Shows the About topic in the help file.
Call ShowHelpTopic(Hlp_About_Number)

End Sub

Sub mnuHelpContents_Click (Index As Integer)

Call ShowHelpContents

End Sub

Sub mnuHelpRegister_Click (Index As Integer)

Dim x As Integer

x = Shell(app.Path + "\BASEREG.EXE", 1)

End Sub

Sub mnuHelpRegisteringInfo_Click (Index As Integer)

Call ShowHelpTopic(hlp_Registering)

End Sub

Sub txtDisplay_Change ()

Display = txtDisplay

End Sub

Sub txtDisplay_GotFocus ()

'Move the cursor to the far right of the display

txtDisplay.SelStart = Len(txtDisplay)

End Sub

Sub txtDisplay_KeyPress (KeyAscii As Integer)

'Filter keypresses to ensure that no invalid keys are
'pressed


'Declare the array containing characters used for digits
'in different bases.
Static BaseChars(0 To 35) As String

Dim count As Integer    'used in checking the character


Select Case KeyAscii

Case 8: Exit Sub    'Backspace
'Case 46: Exit Sub   'Decimal point .
Case 48 To 57:  'Digits
Case 65 To 90:  'Upper case letters
Case 97 To 122: 'Lower case letters
    '(change lower case letters to capitals)
    KeyAscii = KeyAscii - 32

Case Else:      'Block out an invalid key
    Beep
    KeyAscii = 0
    Exit Sub
End Select


'If the test gets to here, the character needs checking
'to ensure that it is a valid character in the current
'base.

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"

'Test the character

For count = 0 To (Current_Base - 1)
    If Chr$(KeyAscii) = BaseChars(count) Then Exit Sub  'Found the character
Next count

'If it gets to here, the character was not found

Beep
KeyAscii = 0

End Sub

Sub txtFocusBox_Change ()

'The purpose of this text box is to provide a focus
'for the cursor. Keys being pressed are then inserted
'into the main display, lblDisplay.

End Sub

